IF NOT EXISTS (SELECT * FROM sys.objects
WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA]')
AND type in (N'U'))

BEGIN

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON

CREATE TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA](
	[CD_EMP] [int] NOT NULL,
	[CD_CTR_AGENDA] [int] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[JUSTIFICATIVA] [varchar](255) NOT NULL,

	[TIPO_AGENDA] [tinyint] NOT NULL,
	[DS_AGENDAMENTO] [varchar](50) NOT NULL,
	[FREQ_REV] [tinyint] NOT NULL,
	[LEAD_TIME] [int] NOT NULL,
	[TIPO_FRETE] [tinyint] NOT NULL,
	[COMPRA_EMBALADO] [tinyint] NOT NULL,
	[COMPRA_MULTIPLO] [tinyint] NOT NULL,
	[PERC_DESC_COMERCIAL] [money] NOT NULL,
	[PERC_DESC_FINANCEIRO] [money] NOT NULL,
	[PRZ_PGTO] [tinyint] NOT NULL,
	[SEGUNDA] [tinyint] NOT NULL,
	[TERCA] [tinyint] NOT NULL,
	[QUARTA] [tinyint] NOT NULL,
	[QUINTA] [tinyint] NOT NULL,
	[SEXTA] [tinyint] NOT NULL,
	[SABADO] [tinyint] NOT NULL,
	[DOMINGO] [tinyint] NOT NULL,
	[PARAM_EST] [tinyint] NOT NULL,
	[DT_AGENDAMENTO_DEFAULT] [datetime] NULL,
	[INDICADOR_SUPRIMENTO] [tinyint] NOT NULL,
	[TIPO_COMPRA] [tinyint] NOT NULL,	
	[QT_DIAS_ACRES_AGENDA] [int] NOT NULL,
	[DT_VALID_ACRES_AGENDA] [datetime] NULL,
	[FLAG_GERAR_AGENDA] [tinyint] NOT NULL,
	[FLAG_EXPORTA_NEOGRID] [tinyint] NOT NULL,
	[FLAG_LST_PRECO] [tinyint] NULL,
	[FLAG_GRUPO_POSSUI_PRODUTOS] [tinyint] NOT NULL, 
	[STS_AGENDA] [tinyint] NOT NULL, 
	[CD_COMPRADOR] [int] NULL, -- NULL SE FOR RESSUPRIMENTO
	[CD_FILIAL_DEPO] [int] NULL, -- NULL SE FOR SUPRIMENTO OU PEDIDO
	[CD_USU] [int] NULL, -- CD_USU DO COMPRADOR
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU_ALT] [int] NOT NULL, -- CD_USU QUE CADASTROU OU REALIZOU A ULTIMA ALTERACAO
	[DT_ULT_ALT] [datetime] NOT NULL, -- DATA EM QUE CADASTROU OU REALIZOU A ULTIMA ALTERACAO

	CONSTRAINT [PK_EST_PROD_AGENDA_COMPRA_AUDITORIA] PRIMARY KEY CLUSTERED 
	(	[CD_EMP] ASC,
		[CD_CTR_AGENDA] ASC,
		[CD_CTR] ASC
	) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	   ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA]  WITH CHECK ADD  
		CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_EST_PROD_AGENDA_COMPRA] FOREIGN KEY([CD_CTR_AGENDA]) 
	    REFERENCES [EST_PROD_AGENDA_COMPRA] ([CD_CTR_AGENDA])
	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA] CHECK CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_EST_PROD_AGENDA_COMPRA]

	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA]  WITH CHECK ADD  
		CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_GLB_USU] FOREIGN KEY([CD_USU])
		REFERENCES [dbo].[GLB_USU] ([CD_USU])
	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA] CHECK CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_GLB_USU]

	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA]  WITH CHECK ADD  
		CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_GLB_USU_ALT] FOREIGN KEY([CD_USU_ALT])
		REFERENCES [dbo].[GLB_USU] ([CD_USU])
	ALTER TABLE [dbo].[EST_PROD_AGENDA_COMPRA_AUDITORIA] CHECK CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_AUDITORIA_GLB_USU_ALT]
END